

#include <stdio.h>
#include <windows.h>
#include <commctrl.h>
#include <wincon.h>
#include "window.rc.h"



#define APP_IDENAME "StrictAL IDE"
#define APP_HOMEPAGE "https://www.heroesden.link"
#define APP_PROJECTNAME_MAXLEN 32
#define APP_FILES_MAX 64
#define APP_FILENAME_MAXLEN 32




HINSTANCE IDE_hInstance = NULL;

HWND IDE_hConsole = NULL;
HWND IDE_hWndMain = NULL;
HFONT App_hfGUI = NULL;




HWND App_hWndHelpAbout = NULL;
HWND App_hWndHelpAbout_Build = NULL;
HWND App_hWndHelpAbout_Homepage = NULL;



WNDPROC IDE_wpBaseButton = NULL;




HWND App_hWndFileList = 0;
HWND App_hWndEditorTabs = 0;

//	Position of an item of menu is counted from zero (0).
//
HMENU App_hMainMenu = NULL;
HMENU App_hSubmenuProject = NULL;




char App_ProjectName[APP_PROJECTNAME_MAXLEN] = "";
char App_ProjectFiles[APP_FILES_MAX][APP_FILENAME_MAXLEN] = {0};



//	All virtual keys must be only in upper case.
//
ACCEL App_accelList[] =
{
	{ FCONTROL | FVIRTKEY, 'N', ID_MAINMENU_FILE_NEWPROJECT }, // CTRL + N
	{ FCONTROL | FVIRTKEY, 'A', ID_CMD_SELECT_ALL } // CTRL + A
};
HACCEL App_hAccel = NULL;










void IDE_Error(char *msg);
void IDE_Log(char *msg);
void IDE_AddConsole(void);
void App_RegisterWndClasses(void);
void App_CreateWndMain(int nCmdShow);
void App_CreateDlg_HelpAbout(void);
void App_AddMenuMainWindow(void);
void App_CreateAccelTable(void);
void App_CreateFileList(void);
void App_CreateEditorTabs(void);
void App_ClickOnMenu_Help_About(void);
void App_ClickOn_File_Newproject(HWND hwnd);
void App_ClickOn_Project_Newfile(HWND hwnd);
void App_CenterWindow(HWND hwnd);
void App_CenterDialogBoxes(WPARAM wParam, LPARAM lParam);
void App_SetDefFont(HWND hWnd);
void IDE_ClickOnControl(HWND hParent, int nCtrlId);
void IDE_ClickOnClose(HWND hWnd);
void IDE_SetFocusOnOK(HWND hWnd);
void IDE_RotateFocus(HWND hParent, const int *table, int num);
HWND App_AddTooltip(HWND hParent, UINT childId, char *text);





LRESULT CALLBACK App_MainWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{

		case WM_ACTIVATE:
		{
			//App_CenterDialogBoxes(wParam, lParam);

			char classname[256];
			HWND hChild = (HWND) lParam;

			//	Is focus switched from main window to child dialog box?
			//
			if(wParam == WA_INACTIVE)
			{

				GetClassName(hChild, classname, sizeof(classname) - 1);
	
				//	Classname for all common dialog boxes is "#32770".
				//
				if(strcmp(classname, "#32770") == 0)
				{
					App_CenterWindow(hChild);
					return 0;
				}

				//if(strcmp(classname, "wcModalDialog") == 0)
				//{
				//	App_CenterWindow(hChild);
				//	EnableWindow(hwnd, FALSE);
				//	return 0;
				//}
			}


		}
		break;


		case WM_NOTIFY:
		{
		}
		break;


		//
		//
		case WM_CREATE:
		break;


		//
		//
		case WM_COMMAND:

			switch(LOWORD(wParam))
			{
				case ID_CMD_SELECT_ALL:
				IDE_Log("Testing");
				break;


				case ID_MAINMENU_FILE_NEWPROJECT:
				App_ClickOn_File_Newproject(hwnd);
				break;

				case ID_MAINMENU_FILE_EXIT:
				PostMessage(hwnd, WM_CLOSE, 0, 0);
				break;

				case ID_MAINMENU_PROJECT_NEWFILE:
				App_ClickOn_Project_Newfile(hwnd);
				break;

				case ID_MAINMENU_HELP_ABOUT:
				App_ClickOnMenu_Help_About();
				break;
            }
        break;


		//
		//
		case WM_LBUTTONDOWN:
		break;


		//
		//
		case WM_CLOSE:
		DestroyWindow(hwnd);
		break;


		//
		//
		case WM_DESTROY:
		PostQuitMessage(0);
		break;


		//
		//
        default:
		return DefWindowProc(hwnd, msg, wParam, lParam);
	}

	return 0;
}


//	Base window procedure for all dialogs.
//
LRESULT CALLBACK IDE_wpModalDlg(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
		case WM_CLOSE:
		{
			//	Hide dialog (not destroy) and return focus to the parent
			//	window.
			//
			HWND hParent = GetParent(hWnd);

			EnableWindow(hParent, TRUE);
			ShowWindow(hWnd, SW_HIDE);

			return 0;
		}
		break;
	}

	return CallWindowProc(DefWindowProc, hWnd, msg, wParam, lParam);
}


//	Subclass window procedure for <Help - About> dialog derived from
//	App_ModalDlgProc().
//
LRESULT CALLBACK IDE_wpModalDlg_HelpAbout(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	const int focusTable[] =
	{
		ID_DLG_ABOUT_HELP_URL,
		IDOK
	};


	switch(msg)
	{


		case WM_CHAR:
		{

			if(wParam == VK_TAB)
			{
				IDE_RotateFocus(hWnd, focusTable, (sizeof(focusTable) / sizeof(focusTable[0])));
				return 0;
			}
			if(wParam == VK_RETURN)
			{
				//	Click on OK button.
				//
				IDE_ClickOnControl(hWnd, IDOK);
				return 0;
			}
			if(wParam == VK_ESCAPE)
			{
				SendMessage(hWnd, WM_CLOSE, NULL, NULL);
				return 0;
			}
		}
		break;


		case WM_COMMAND:
		{
			WORD control = LOWORD(wParam);

			//	The user pressed button with homepage URL.
			//
			if(control == ID_DLG_ABOUT_HELP_URL)
			{
				ShellExecute(NULL, "open", APP_HOMEPAGE, NULL, NULL, SW_SHOWNORMAL);
				return 0;
			}

			//	The user pressed OK button.
			//
			if(control == IDOK)
			{
				SendMessage(hWnd, WM_CLOSE, NULL, NULL);
				return 0;
			}
		}
		break;
	}

	return CallWindowProc(IDE_wpModalDlg, hWnd, msg, wParam, lParam);
}










LRESULT CALLBACK IDE_wpButton(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{


		case WM_CREATE:
		{
			App_SetDefFont(hWnd);
		}
		break;


		case WM_CHAR:
		{
			//	Forward pressing of ESC and TAB keys to a parent window.
			//
			if(wParam == VK_ESCAPE || wParam == VK_TAB)
			{
				SendMessage(GetParent(hWnd), msg, wParam, lParam);
				return 0;
			}

			//	Emulate click of mouse's left button on the control.
			//
			if(wParam == VK_RETURN)
			{
				IDE_ClickOnControl(hWnd, NULL);
				return 0;
			}


		}
		break;
	}

	return CallWindowProc(IDE_wpBaseButton, hWnd, msg, wParam, lParam);
}












int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow)
{
    MSG Msg;
	IDE_hInstance = hInst;

	IDE_AddConsole();

	App_hfGUI = GetStockObject(DEFAULT_GUI_FONT);
	if(App_hfGUI == NULL)
		IDE_Error("Can't get DEFAULT_GUI_FONT stock object.");


	InitCommonControls();


	App_RegisterWndClasses();
	App_CreateWndMain(nCmdShow);
	App_CreateDlg_HelpAbout();
	App_AddMenuMainWindow();
	App_CreateAccelTable();
	App_CreateFileList();
	App_CreateEditorTabs();


	while(GetMessage(&Msg, NULL, 0, 0) > 0)
	{
		if(TranslateAccelerator(IDE_hWndMain, App_hAccel, &Msg)) continue;

		TranslateMessage(&Msg);
		DispatchMessage(&Msg);
	}


	(void) hPrevInst;
	(void) lpCmdLine;
	return Msg.wParam;
}




void IDE_Error(char *msg)
{
	char buf[240];

	snprintf(buf, sizeof(buf), "%s\n\nError code: %lu.", msg, GetLastError());
	MessageBox(IDE_hWndMain, buf, "Critical error", MB_OK | MB_ICONERROR);

	//if(abortApp)
		exit(EXIT_FAILURE);
}





void IDE_Log(char *msg)
{
	HANDLE hOut;
	char buf[240];
	static int i = 0;

	if(IDE_hConsole == NULL)
		IDE_Error("Can't write log (the console is not allocated).");

	snprintf(buf, sizeof(buf), "#%d %s\n", i, msg);

	hOut = GetStdHandle(STD_OUTPUT_HANDLE);
	WriteConsole(hOut, buf, strlen(buf), NULL, NULL);

	i++;
}






void IDE_AddConsole(void)
{
	HMONITOR hMon;
	MONITORINFO monInfo;

	HANDLE hOut;
	CONSOLE_SCREEN_BUFFER_INFO conInfo;
	COORD bufSize;
	RECT rcCon;
	int width, height, x, y;
	UINT flags;


	//	Allocate a console.
	//
	if(AllocConsole() == 0)
		IDE_Error("Can't allocate console.");


	//	Make handle of the console global.
	//
	IDE_hConsole = FindWindow("ConsoleWindowClass", NULL);
	if(IDE_hConsole == NULL)
		IDE_Error("Can't find handle of the console.");


	//	Change buffer size of the console.
	//
	hOut = GetStdHandle(STD_OUTPUT_HANDLE);

	if(hOut == NULL || hOut == INVALID_HANDLE_VALUE)
		IDE_Error("Can't get STD_OUTPUT_HANDLE.");


	if(GetConsoleScreenBufferInfo(hOut, &conInfo) == 0)
		IDE_Error("Can't get information about console buffer.");

	//	Don't change X here because it is pointless. The operating system
	//	doesn't get you to do it. You need to change size of the window not a
	//	buffer.
	//
	//	It is have to be like this, but no luck:
	//	bufSize.X = (conInfo.dwSize.X < 80) ? 80 : conInfo.dwSize.X;
	//
	//	I think Y should be multiply of 80 for paragraph alignment.
	//
	bufSize.X = conInfo.dwSize.X;
	bufSize.Y = (conInfo.dwSize.Y > 240) ? 240 : conInfo.dwSize.Y;

	if(SetConsoleScreenBufferSize(hOut, bufSize) == 0)
		IDE_Error("Can't change buffer size of the console.");


	//	Determine active monitor and move the console.
	//
	hMon = MonitorFromWindow(IDE_hConsole, MONITOR_DEFAULTTOPRIMARY);

	monInfo.cbSize = sizeof(monInfo);
	if(GetMonitorInfo(hMon, &monInfo) == 0)
		IDE_Error("Can't get information about monitor while attaching the console.");

	x = monInfo.rcWork.left;
	y = monInfo.rcWork.top;

	if(GetWindowRect(IDE_hConsole, &rcCon) == 0)
		IDE_Error("Can't get window size of the console.");


	//	Try to normalize width of the console to about 80 characters (79
	//	characters of a text + '\n').
	//
	if(bufSize.X == 80)
	{
		width = rcCon.right - rcCon.left;
	}
	else
	{
		width = (rcCon.right - rcCon.left) * (80.0 / (bufSize.X - 3));
	}

	height = monInfo.rcWork.bottom - monInfo.rcWork.top;

	flags = (IDE_hWndMain == NULL) ? SWP_NOZORDER : NULL;

	if(SetWindowPos(IDE_hConsole, IDE_hWndMain, x, y, width, height, flags) == 0)
		IDE_Error("Can't move the console.");


	//	Is it needed to minimize the console on startup?
	//
	//	ShowWindow(App_hConsole, SW_MINIMIZE);
	//
}







void App_RegisterWndClasses(void)
{
	int i;

	HCURSOR cursor = LoadCursor(NULL, IDC_ARROW);

	WNDCLASSEX wc[3] = {0};


	//	Window class for main window.
	//
	i = 0;
	wc[i].cbSize = sizeof(WNDCLASSEX);
	wc[i].style = NULL;
	wc[i].lpfnWndProc = App_MainWndProc;
	wc[i].cbClsExtra = 0;
	wc[i].cbWndExtra = 0;
	wc[i].hInstance = IDE_hInstance;
	wc[i].hIcon = LoadIcon(IDE_hInstance, MAKEINTRESOURCE(ID_APP_ICON));
	wc[i].hCursor = cursor;
	wc[i].hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
	wc[i].lpszMenuName = NULL;
	wc[i].lpszClassName = "wcMain";
	wc[i].hIconSm = (HICON)LoadImage(IDE_hInstance, MAKEINTRESOURCE(ID_APP_ICON), IMAGE_ICON, 16, 16, NULL);


	//	Window class for modal dialogs.
	//
	i = 1;
	wc[i].cbSize = sizeof(WNDCLASSEX);
	wc[i].style = NULL;
	wc[i].lpfnWndProc = IDE_wpModalDlg;
	wc[i].cbClsExtra = 0;
	wc[i].cbWndExtra = 0;
	wc[i].hInstance = IDE_hInstance;
	wc[i].hIcon = NULL;
	wc[i].hCursor = cursor;
	wc[i].hbrBackground = (HBRUSH)(COLOR_MENU + 1);
	wc[i].lpszMenuName = NULL;
	wc[i].lpszClassName = "wcModalDialog";
	wc[i].hIconSm = NULL;


	//	Window superclass for buttons.
	//
	i = 2;
	wc[i].cbSize = sizeof(WNDCLASSEX);
	if(GetClassInfoEx(NULL, "BUTTON", &wc[i]) == FALSE)
		IDE_Error("Can't get information about <BUTTON> class.");

	IDE_wpBaseButton = wc[i].lpfnWndProc;
	wc[i].lpfnWndProc = IDE_wpButton;
	wc[i].hInstance = IDE_hInstance;
	wc[i].lpszClassName = "wcButton";


	//	Register all window classes.
	//
	for(i = 0; i < (sizeof(wc) / sizeof(WNDCLASSEX)); i++)
	{
		if(!RegisterClassEx(&wc[i]))
		{
			char buf[128];
			snprintf(buf, sizeof(buf), "Can't register window class.\n\nClass ID: %d\nClass name: %s.", i, wc[i].lpszClassName);
			IDE_Error(buf);
		}
	}
}










void App_CreateWndMain(int nCmdShow)
{
	int x, y;
	int width = 640;
	int height = 480;

	//	Place main window on the center of the screen.
	//
	x = (GetSystemMetrics(SM_CXSCREEN) - width) / 2;
	y = (GetSystemMetrics(SM_CYSCREEN) - height) / 2;


	IDE_hWndMain = CreateWindowEx
	(
		WS_EX_CLIENTEDGE,
		"wcMain",
		"StrictAL IDE",
		WS_OVERLAPPEDWINDOW,
		x, y, width, height,
		NULL, NULL, IDE_hInstance, NULL
	);


	if(IDE_hWndMain == NULL)
		IDE_Error("Can't create main window.");


	ShowWindow(IDE_hWndMain, nCmdShow);
	UpdateWindow(IDE_hWndMain);
}





void App_CreateDlg_HelpAbout(void)
{
	HWND wnd;
	HWND ctrl;
	char buf[128];

	//	Create <Help - About> dialog.
	//
	wnd = CreateWindowEx
	(
		WS_EX_DLGMODALFRAME,
		"wcModalDialog",
		"About IDE",
		WS_CAPTION | WS_SYSMENU | WS_POPUP,
		CW_USEDEFAULT, CW_USEDEFAULT, 246, 176,
		IDE_hWndMain, NULL, IDE_hInstance, NULL
	);


	if(wnd == NULL)
		IDE_Error("Can't create <Help-About> dialog.");


	if(SetWindowLongPtr(wnd, GWLP_WNDPROC, (LONG_PTR)IDE_wpModalDlg_HelpAbout) == 0)
		IDE_Error("Can't change window procedure of <Help-About> dialog.");


	App_hWndHelpAbout = wnd;


	//	Build date.
	//
	snprintf(buf, sizeof(buf), "Build: %s %s", __TIME__, __DATE__);
	ctrl = CreateWindowEx(NULL, "STATIC", buf, WS_VISIBLE | WS_CHILD | SS_SIMPLE, 15, 18, 150, 20,
		wnd, NULL, IDE_hInstance, NULL);
	App_SetDefFont(ctrl);


	//	Homepage.
	//
	ctrl = CreateWindowEx(NULL, "STATIC", "Homepage:", WS_VISIBLE | WS_CHILD | SS_SIMPLE, 15, 49, 150, 20,
		wnd, NULL, IDE_hInstance, NULL);
	App_SetDefFont(ctrl);


	//	Homepage URL.
	//
	ctrl = CreateWindowEx(NULL, "wcButton", APP_HOMEPAGE, WS_VISIBLE | WS_CHILD | BS_FLAT, 75, 44, 150, 24,
		wnd, (HMENU)ID_DLG_ABOUT_HELP_URL, IDE_hInstance, NULL);


	//	OK button.
	//
	ctrl = CreateWindowEx(NULL, "wcButton", "OK", WS_VISIBLE | WS_CHILD, 155, 108, 70, 24,
		wnd, (HMENU)IDOK, IDE_hInstance, NULL);
}





void App_AddMenuMainWindow(void)
{
	HMENU hSubmenu;

	App_hMainMenu = CreateMenu();

	//	Menu -> File -> ...
	//
	hSubmenu = CreatePopupMenu();
	AppendMenu(App_hMainMenu, MF_STRING | MF_POPUP, (UINT)hSubmenu, "&File");
	AppendMenu(hSubmenu, MF_STRING, ID_MAINMENU_FILE_NEWPROJECT, "&New project\tCtrl+N");
	AppendMenu(hSubmenu, MF_SEPARATOR, -1, "");
	AppendMenu(hSubmenu, MF_STRING, ID_MAINMENU_FILE_EXIT, "E&xit");

	//	Menu -> Project -> ...
	//
	hSubmenu = CreatePopupMenu();
	AppendMenu(App_hMainMenu, MF_STRING | MF_POPUP | MF_GRAYED, (UINT)hSubmenu, "Project");
	AppendMenu(hSubmenu, MF_STRING, ID_MAINMENU_PROJECT_NEWFILE, "New file");
	App_hSubmenuProject = hSubmenu;

	//	Menu -> Help -> ...
	//
	hSubmenu = CreatePopupMenu();
	AppendMenu(App_hMainMenu, MF_STRING | MF_POPUP, (UINT)hSubmenu, "&Help");
	AppendMenu(hSubmenu, MF_STRING, ID_MAINMENU_HELP_ABOUT, "About");


	SetMenu(IDE_hWndMain, App_hMainMenu);
}




void App_CreateAccelTable(void)
{
	App_hAccel = CreateAcceleratorTable(App_accelList, sizeof(App_accelList) / sizeof(ACCEL));

	if(App_hAccel == NULL)
		IDE_Error("Can't create accelerator table.");
}





//	INFO:
//
//	InitTreeViewImageLists() and InitTreeViewItems() not implement in BCC551.
//
void App_CreateFileList(void)
{
	RECT rcClient;

	GetClientRect(IDE_hWndMain, &rcClient);

	App_hWndFileList = CreateWindowEx
	(
		0,
		WC_TREEVIEW,
		"Tree View",
		WS_VISIBLE | WS_CHILD | WS_BORDER | TVS_HASLINES,
		0,
		0,
		rcClient.right * 0.35,
		rcClient.bottom,
		IDE_hWndMain,
		(HMENU)ID_FILELIST,
		IDE_hInstance,
		NULL
	);

	if(App_hWndFileList == NULL)
		IDE_Error("Can't create WC_TREEVIEW control.");
}




void App_CreateEditorTabs(void)
{
	RECT rcClient;
	TCITEM tci = {0};


	GetClientRect(IDE_hWndMain, &rcClient);


	App_hWndEditorTabs = CreateWindowEx
	(
		0,
		WC_TABCONTROL,
		"Editor Tabs",
		WS_CHILD | WS_VISIBLE | WS_BORDER,
		300,
		0,
		rcClient.right,
		rcClient.bottom, 
        IDE_hWndMain,
		(HMENU)ID_EDITORTABS,
		IDE_hInstance,
		NULL
	);


	if (App_hWndEditorTabs == NULL)
		IDE_Error("Can't create WC_TABCONTROL control.");


	tci.mask = TCIF_TEXT;
	tci.pszText = "tab1";
	tci.cchTextMax = 4;

	if(TabCtrl_InsertItem(App_hWndEditorTabs, 0, &tci) == -1)
		IDE_Error("Can't add item #0 to WC_TABCONTROL.");
}








void App_ClickOnMenu_Help_About(void)
{
	EnableWindow(IDE_hWndMain, FALSE);
	App_CenterWindow(App_hWndHelpAbout);
	ShowWindow(App_hWndHelpAbout, SW_NORMAL);
}











BOOL CALLBACK procClickOn_File_Newproject(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	WORD control = LOWORD(wParam);
	WORD action = HIWORD(wParam);


	{
		//App_Log("Test");
	}

	if(msg == WM_GETDLGCODE)
	{
		IDE_Log("getdlg code");

		return 0;
	}

	//	Initial configuration.
	//
	if(msg == WM_INITDIALOG)
	{
		//	Set maximum number of characters in edit control and set focus on
		//	it.
		//
		HWND hEdit = GetDlgItem(hwndDlg, ID_DLG_FILE_NEWPROJECT_NAME);

		SendMessage(hEdit, EM_LIMITTEXT, APP_PROJECTNAME_MAXLEN - 1, NULL);
		SetFocus(hEdit);

		//	If return TRUE, then first control in the dialogbox will be
		//	focused.
		//
		return FALSE;
	}

	//	Enable CTRL-A combination.
	//
	if(msg == WM_COMMAND && control == ID_CMD_SELECT_ALL)
    {
        //on which control there was pressed Ctrl+A
        //there is no way of getting HWND through wParam and lParam
        //so we get HWND which currently has focus.

        //HWND hFocused = GetFocus();
        //wchar_t className[6];
        //GetClassName(hFocused, className, 6);
        //if (hFocudsed && !wcsicmp(className, L"edit"))
          //  SendMessage(hFocused, EM_SETSEL, 0, -1);

		//App_Log("Hellooooo");
		//return FALSE;
    }


	//	The user change content in edit control.
	//
	if(msg == WM_COMMAND && control == ID_DLG_FILE_NEWPROJECT_NAME && action == EN_CHANGE)
	{
		int nameLen;
		int bufLen;
		int i;
		int begin;
		HWND hOK = GetDlgItem(hwndDlg, IDOK);
		char projectName[APP_PROJECTNAME_MAXLEN] = "";
		char buf[APP_PROJECTNAME_MAXLEN] = "";

		GetDlgItemText(hwndDlg, ID_DLG_FILE_NEWPROJECT_NAME, projectName, sizeof(projectName) - 1);

		//	Is filename empty?
		//
		nameLen = strlen(projectName);

		if(nameLen == 0)
		{
			EnableWindow(hOK, FALSE);
			return FALSE;
		}

		//	Remove invalid characters from user's input.
		//
		for(i = 0; i < nameLen; i++)
		{
			if(projectName[i] >= 32 && projectName[i] <= 126) strncat(buf, projectName + i, 1);
		}

		bufLen = strlen(buf);

		//	The input contains only invalid characters.
		//
		if(bufLen == 0)
		{
			SetDlgItemText(hwndDlg, ID_DLG_FILE_NEWPROJECT_NAME, "");
			EnableWindow(hOK, FALSE);
			return FALSE;
		}

		//	Find first visible character (non space) in the input.
		//
		begin = -1;
		for(i = 0; i < bufLen; i++)
		{
			if(buf[i] != ' ')
			{
				begin = i;
				break;
			}
		}

		//	The input consists of spaces only.
		//
		if(begin == -1)
		{
			SetDlgItemText(hwndDlg, ID_DLG_FILE_NEWPROJECT_NAME, "");
			EnableWindow(hOK, FALSE);
			return FALSE;
		}

		//	If the input doesn't contain invalid characters and spaces in the
		//	beginning then all is fine.
		//
		if(begin == 0 && nameLen == bufLen)
		{
			EnableWindow(hOK, TRUE);
			return FALSE;
		}

		//	Remove spaces from the beginning of the input.
		//
		i = bufLen - begin;
		strncpy(projectName, buf + begin, i);
		projectName[i] = '\0';
		SetDlgItemText(hwndDlg, ID_DLG_FILE_NEWPROJECT_NAME, projectName);

		//	Move caret to the end of the edit.
		//
		SendDlgItemMessage(hwndDlg, ID_DLG_FILE_NEWPROJECT_NAME, EM_SETSEL, i, i);


		EnableWindow(hOK, TRUE);


		return FALSE;
	}


	//	The user pressed "OK" or "Cancel" button.
	//
	if(msg == WM_COMMAND)
	{
		if(control == IDOK)
		{
			char buf[128];
			HWND hSubmenu;



		//	Find the last visible characters (non space) in the input.
		//
		/*
		end = -1;
		for(i = len - 1; i >= 0; i--)
		{
			if(buf[i] != ' ')
			{
				end = i;
				break;
			}
		}*/


			//	Change title of the main window.
			//
			GetDlgItemText(hwndDlg, ID_DLG_FILE_NEWPROJECT_NAME, App_ProjectName, sizeof(App_ProjectName) - 1);

			snprintf(buf, sizeof(buf), "%s - %s", APP_IDENAME, App_ProjectName);
			SetWindowText(IDE_hWndMain, buf);

			//	Enable "Project" popup in the main menu.
			//
			EnableMenuItem(App_hMainMenu, (UINT)App_hSubmenuProject, MF_BYCOMMAND | MF_ENABLED);


			EndDialog(hwndDlg, IDOK);
			return TRUE;
		}
		else if(control == IDCANCEL)
		{
			EndDialog(hwndDlg, IDCANCEL);
			return TRUE;
		}
	}

	(void) lParam;
	return FALSE;
}
void App_ClickOn_File_Newproject(HWND hwnd)
{
	//	Is some project already opened?
	//
	if(strlen(App_ProjectName) != 0)
	{
		MessageBox(hwnd, "Some project is already opened. You have to close it before create a new one.", "Error", MB_OK | MB_ICONEXCLAMATION);
		return;
	}

	DialogBox(IDE_hInstance, MAKEINTRESOURCE(ID_DLG_FILE_NEWPROJECT), hwnd, (DLGPROC)procClickOn_File_Newproject);
}







BOOL CALLBACK procClickOn_Project_Newfile(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	//	Initial configuration.
	//
	if(msg == WM_INITDIALOG)
	{
		int i;
		HWND hName = GetDlgItem(hwndDlg, ID_DLG_PROJECT_NEWFILE_NAME);
		HWND hCombobox = GetDlgItem(hwndDlg, ID_DLG_PROJECT_NEWFILE_EXT);

		char *extension[] =
		{
			"Source code (*.sals)"
		};

		//SendMessage(hEdit, EM_LIMITTEXT, sizeof(projectName) - 1, 0);
		//SetFocus(hEdit);

		//return FALSE;



		//	Fill up combobox with extensions and select first option.
		//
		for(i = 0; i < (sizeof(extension) / sizeof(char *)); i++)
		{
			SendMessage(hCombobox, CB_ADDSTRING, NULL, (LPARAM)extension[i]);
		}
		SendMessage(hCombobox, CB_SETCURSEL, 0, NULL);


		//	Constrain maximum number of input characters in filename and set
		//	focus.
		//
		SendMessage(hName, EM_LIMITTEXT, APP_FILENAME_MAXLEN - 1, NULL);
		SetFocus(hName);


		return FALSE;
	}

	return FALSE;
}
void App_ClickOn_Project_Newfile(HWND hwnd)
{
	DialogBox(IDE_hInstance, MAKEINTRESOURCE(ID_DLG_PROJECT_NEWFILE), hwnd, (DLGPROC)procClickOn_Project_Newfile);
}















void App_CenterWindow(HWND hChild)
{
	HWND hParent;

	RECT rwParent, rwChild;

	int cWidth, cHeight;
	int pWidth, pHeight;
	int x, y;

	hParent = GetParent(hChild);

	if(hParent == NULL)
		IDE_Error("Can't move child window to the center of the parent window.");

	GetWindowRect(hParent, &rwParent);
	pWidth = rwParent.right - rwParent.left;
	pHeight = rwParent.bottom - rwParent.top;

	GetWindowRect(hChild, &rwChild);
	cWidth = rwChild.right - rwChild.left;
	cHeight = rwChild.bottom - rwChild.top;

	x = rwParent.left + (pWidth - cWidth) / 2;
	y = rwParent.top + (pHeight - cHeight) / 2;

	SetWindowPos(hChild, 0, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
}






//	Move all uncontrolled dialog boxes to the center of the parent window.
//
void App_CenterDialogBoxes(WPARAM wParam, LPARAM lParam)
{
	char classname[256];
	HWND hChild = (HWND) lParam;

	//	Is focus switched from main window to child dialog box?
	//
	if(wParam != WA_INACTIVE) return;

	GetClassName(hChild, classname, sizeof(classname) - 1);

	//	Classname for all common dialog boxes is "#32770".
	//
	if(strcmp(classname, "#32770") != 0) return;

	App_CenterWindow(hChild);
}








void App_SetDefFont(HWND hWnd)
{
	SendMessage(hWnd, WM_SETFONT, (WPARAM)App_hfGUI, MAKELPARAM(TRUE, 0));
}








//	Emulate clicking of mouse's left button on the center of a control. If
//	<nCtrlId> is NULL then it is assumed that <hParent> is a handler to the
//	target control.
//
void IDE_ClickOnControl(HWND hParent, int nCtrlId)
{
	HWND hControl;
	RECT rcControl;
	int x, y; 

	hControl = (nCtrlId == NULL) ? hParent : GetDlgItem(hParent, nCtrlId);
	GetClientRect(hControl, &rcControl);

	x = rcControl.right / 2;
	y = rcControl.bottom / 2;

	SendMessage(hControl, WM_LBUTTONDOWN, NULL, MAKELPARAM(x, y));
	Sleep(50);
	SendMessage(hControl, WM_LBUTTONUP, NULL, MAKELPARAM(x, y));
}




//	Emulate clicking of mouse's left button on the close button (X) placed in
//	the system menu.
//
void IDE_ClickOnClose(HWND hWnd)
{
	/*
	RECT rcClose = {0};
	HMENU hSysMenu;
	int lastItemId;
	int lastItemPos;
	int i;

	hSysMenu = GetSystemMenu(hWnd, FALSE);
	lastItemPos = GetMenuItemCount(hSysMenu) - 1;
	lastItemId = GetMenuItemID(hSysMenu, lastItemPos);


	if(lastItemId != SC_CLOSE)
	{
		SendMessage(hWnd, WM_CLOSE, NULL, NULL);
		return;
	}

	GetMenuItemRect(hWnd, hSysMenu, lastItemPos, &rcClose);
	*/


	RECT rcWindow;
	int x, y;
	float ratio;

	INPUT inputs[2] = {0};


	GetWindowRect(hWnd, &rcWindow);
	x = rcWindow.right - GetSystemMetrics(SM_CXBORDER) - (GetSystemMetrics(SM_CXSIZE) / 2);
	y = rcWindow.top + GetSystemMetrics(SM_CYBORDER) + (GetSystemMetrics(SM_CYSIZE) / 2);



	/*
    int vx = GetSystemMetrics(SM_XVIRTUALSCREEN);
    int vy = GetSystemMetrics(SM_YVIRTUALSCREEN);
    int vw = GetSystemMetrics(SM_CXVIRTUALSCREEN);
    int vh = GetSystemMetrics(SM_CYVIRTUALSCREEN);

    LONG nx = MulDiv(px - vx, 65535, vw - 1);
    LONG ny = MulDiv(py - vy, 65535, vh - 1);

    INPUT in[3] = {};
    in[0].type = INPUT_MOUSE;
    in[0].mi.dx = nx; in[0].mi.dy = ny;
    in[0].mi.dwFlags = MOUSEEVENTF_MOVE | MOUSEEVENTF_ABSOLUTE | MOUSEEVENTF_VIRTUALDESK;
    in[1].type = INPUT_MOUSE; in[1].mi.dwFlags = MOUSEEVENTF_LEFTDOWN;
    in[2].type = INPUT_MOUSE; in[2].mi.dwFlags = MOUSEEVENTF_LEFTUP;

    SendInput(3, in, sizeof(INPUT));
	*/


	//ratio = x / (float)GetSystemMetrics();

	//	Left button is down.
	//
	inputs[0].type = INPUT_MOUSE;
	inputs[0].mi.dx = x;
	inputs[0].mi.dy = y;
	inputs[0].mi.mouseData = NULL;
	inputs[0].mi.dwFlags = MOUSEEVENTF_ABSOLUTE | MOUSEEVENTF_VIRTUALDESK | MOUSEEVENTF_LEFTDOWN;
	inputs[0].mi.time = 2050;
	inputs[0].mi.dwExtraInfo = NULL;

	//	Left button is up.
	//
	memcpy(&inputs[1], &inputs[0], sizeof(inputs[1]));
	inputs[1].mi.dwFlags = MOUSEEVENTF_ABSOLUTE | MOUSEEVENTF_VIRTUALDESK | MOUSEEVENTF_LEFTUP;
	inputs[1].mi.time = 2000;


	SendInput(sizeof(inputs) / sizeof(inputs[0]), inputs, sizeof(inputs[0]));


	{
		char buf[128];
		sprintf(buf, "x = %u, y = %u, w = %u, h = %u", GetSystemMetrics(SM_XVIRTUALSCREEN), GetSystemMetrics(SM_YVIRTUALSCREEN),
					GetSystemMetrics(SM_CXVIRTUALSCREEN), GetSystemMetrics(SM_CYVIRTUALSCREEN));
		IDE_Log(buf);
	}
}







//	Move focus to OK button.
//
void IDE_SetFocusOnOK(HWND hWnd)
{
	HWND hOK = GetDlgItem(hWnd, IDOK);
	SetFocus(hOK);
}









//
//
void IDE_RotateFocus(HWND hParent, const int *table, int num)
{
	int i;
	HWND hWnd;
	int nResId;

	hWnd = GetFocus();

	//	Focus on a dialog window, not a control.
	//
	if(hParent == hWnd)
	{
		SetFocus(GetDlgItem(hParent, table[0]));
		return;
	}


	nResId = GetWindowLongPtr(hWnd, GWLP_ID);


	for(i = 0; i < num; i++)
	{
		if(nResId == table[i])
		{
			i++;
			break;
		}
	}

	//	Focus was on the last control, move it to the first control from the
	//	table.
	//
	if(i >= num) i = 0;
	SetFocus(GetDlgItem(hParent, table[i]));
}










HWND App_AddTooltip(HWND hParent, UINT childId, char *text)
{
	TOOLINFO toolInfo = {0};

	HWND hChild = GetDlgItem(hParent, childId);

	HWND hTooltip = CreateWindowEx
	(
		NULL, TOOLTIPS_CLASS, NULL,
		WS_POPUP | TTS_ALWAYSTIP,
		CW_USEDEFAULT, CW_USEDEFAULT,
		CW_USEDEFAULT, CW_USEDEFAULT,
		hParent, NULL,
		IDE_hInstance, NULL
	);

	// Associate the tooltip with the tool.
	//
	toolInfo.cbSize = sizeof(toolInfo);
	toolInfo.hwnd = hParent;
	toolInfo.uFlags = TTF_IDISHWND | TTF_SUBCLASS;
	toolInfo.uId = (UINT_PTR)hChild;
	toolInfo.lpszText = text;

	SendMessage(hTooltip, TTM_ADDTOOL, 0, (LPARAM)&toolInfo);



	//	HOW TO USE
	//

		//	Add tooltip.
		//
		//App_AddTooltip(hwndDlg, ID_DLG_FILE_NEWPROJECT_NAME, "tatssty/");


		//	MANUAL CONTROL.
		//
		//SendMessage(hwndTip, TTM_TRACKPOSITION, 0, MAKELPARAM(screenX, screenY));
		
		// show the tracking tooltip for the tool identified by TOOLINFO
		//SendMessage(hwndTip, TTM_TRACKACTIVATE, TRUE, (LPARAM)&toolInfo);
		
		// to hide it later:
		//SendMessage(hwndTip, TTM_TRACKACTIVATE, FALSE, (LPARAM)&toolInfo);







	return hTooltip;
}




































